/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoundEffects {
    private Hashtable<String, SoundClip> soundHash;
    private SourceDataLine[] oldLines;
    private int maxIndex;
    private SoundClip defaultClip;

    public SoundEffects(String string, String ... stringArray) {
        this.maxIndex = stringArray.length;
        this.oldLines = new SourceDataLine[3];
        this.soundHash = new Hashtable();
        this.defaultClip = new SoundClip(string);
        this.soundHash.put(string, this.defaultClip);
        for (int i = 0; i < this.maxIndex; ++i) {
            this.soundHash.put(stringArray[i], new SoundClip(stringArray[i]));
        }
        try {
            this.oldLines[2] = (SourceDataLine)AudioSystem.getLine(this.defaultClip.info);
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println("ERROR (/dev/audio): " + lineUnavailableException.toString());
            System.exit(-1);
        }
    }

    public void play(String string) {
        SoundClip soundClip = this.soundHash.containsKey(string) ? this.soundHash.get(string) : this.defaultClip;
        try {
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(soundClip.info);
            sourceDataLine.open(soundClip.format);
            sourceDataLine.start();
            int n = sourceDataLine.write(soundClip.sample, 0, soundClip.bytes);
            if (this.oldLines[2] != null) {
                this.oldLines[2].close();
            }
            this.oldLines[2] = this.oldLines[1];
            this.oldLines[1] = this.oldLines[0];
            this.oldLines[0] = sourceDataLine;
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println("ERROR (new line): " + lineUnavailableException.toString());
        }
    }
}

